<%@ Control Language="C#" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI.Editor" TagPrefix="tools" %>
<script type="text/javascript">
	var $ = $telerik.$;
	var TABLE_ROW = "tr";
	var TABLE_HEADER = "th";

	Type.registerNamespace("Telerik.Web.UI.Widgets");
	Telerik.Web.UI.Widgets.AccessibleTable = function (element) {
		Telerik.Web.UI.Widgets.AccessibleTable.initializeBase(this, [element]);

		this._clientParameters = null;
		this._table = null
		this._tableDocument = null;

		this._headingRows = 0;
		this._headingColumns = 0;
		this._caption = "";
		this._summary = "";
		this._captionHalign = "";
		this._captionValign = "";
		this._setCellID = false;

		this._headingRowsInput = null;
		this._headingColumnsInput = null;
		this._captionTextArea = null;
		this._summaryTextArea = null;
		this._setCellIDCheckBox = null;

		this._alignmentSelector = null;
	}

	Telerik.Web.UI.Widgets.AccessibleTable.prototype = {
		initialize: function () {
			Telerik.Web.UI.Widgets.AccessibleTable.callBaseMethod(this, "initialize");
			this._initializeChildren();
		},

		_initializeChildren: function () {
			this._headingRowsInput = $find("headingRows");
			this._headingColumnsInput = $find("headingColumns");
			this._captionTextArea = $get("CaptionText");
			this._summaryTextArea = $get("SummaryText");
			this._setCellIDCheckBox = $get("associateCellsWithHeaders");

			this._alignmentSelector = $find("alignmentSelector");
		},

		clientInit: function (clientParameters) {
			this._clientParameters = clientParameters;
			if (this._clientParameters) {
				this._table = this._clientParameters.tableToModify;
				this._tableDocument = this._clientParameters.tableDocument;
			}

			this._loadData();
		},

		_loadData: function () {
			if (this._table)	// retreive table's data
			{
				// caption
				var caption = this._table.caption;
				if (caption) {
					this._captionHalign = this._getCaptionHalign(caption);
					this._captionValign = this._getCaptionValign(caption);
					if ($telerik.isIE) // IE
						this._caption = this._table.caption.innerText;
					else // NS
						this._caption = this._table.caption.childNodes[0].nodeValue;
				}
				else {
					this._caption = '';
					this._captionHalign = '';
					this._captionValign = '';
				}
				this._alignmentSelector.setTagName("CAPTION");
				this._alignmentSelector.updateValue(this._captionHalign, this._captionValign);

				// summary
				this._summary = this._table.summary;
				// heading
				this._headingRows = this._countHeadingRows();;
				this._headingColumns = this._countHeadingColumns();
				this._setCellID = this._checkHeadersHasIds() || this._checkCellsHasHeaders();

				// show data
				this._updateData(false);
			}
		},

		_countHeadingRows: function () {
			var rowsCount = 0;
			var table = this._table;
			var tHead = this._getThead();

			if (tHead) {
				rowsCount = table.tHead.rows.length;
			} else {
				$telerik.$(TABLE_ROW, table).each(function () {
					if ($telerik.$(TABLE_HEADER, this).length > 0)
						rowsCount++;
				});
			}

			return rowsCount;
		},

		_countHeadingColumns: function () {
			var count = 0;
			var i;
			var k;
			var cells;

			if (this._table) {
				var tHead = this._getThead();
				if (tHead) {
					for (i = 0; i < tHead.rows.length; i++) {
						var row = tHead.rows[i];
						var cells = row.getElementsByTagName('TH');
						if ((cells && cells.length < count) || count == 0)
							count = cells.length;
					}
				}
				for (k = 0; k < this._table.tBodies.length; k++) {
					var tBody = this._table.tBodies[k];
					for (i = 0; i < tBody.rows.length; i++) {
						var row = tBody.rows[i];
						cells = $telerik.$(row).children(TABLE_HEADER);

						if ((cells && cells.length < count) || count == 0)
							count = cells.length;
					}
				}
			}
			return count;
		},

		_checkCellsHasHeaders: function () {
			if (this._table) {
				for (k = 0; k < this._table.tBodies.length; k++) {
					var tBody = this._table.tBodies[k];
					for (i = 0; i < tBody.rows.length; i++) {
						var row = tBody.rows[i];
						for (j = 0; j < row.cells.length; j++) {
							var cell = row.cells[j];
							if (cell.getAttribute('headers')) {
								return true;
							}
						}
					}
				}
			}
			return false;
		},

		_checkHeadersHasIds: function () {
			if (this._table) {
				for (i = 0; i < this._table.rows.length; i++) {
					var row = this._table.rows[i];
					for (j = 0; j < row.cells.length; j++) {
						var cell = row.cells[j];
						if ("TH" == cell.tagName.toUpperCase() && "" != cell.id)
							return true;
					}
				}
			}
			return false;
		},

		_updateData: function (save) {
			if (save) // retreive data from controls
			{
				this._headingRows = parseInt(this._headingRowsInput.get_value());
				this._headingColumns = parseInt(this._headingColumnsInput.get_value());
				this._caption = this._captionTextArea.value;
				this._summary = this._summaryTextArea.value;

				this._captionHalign = this._alignmentSelector.getAlign();
				this._captionValign = this._alignmentSelector.getVAlign();

				this._setCellID = this._setCellIDCheckBox.checked;
			}
			else	// set data to controls
			{
				this._headingRowsInput.set_value(this._headingRows ? this._headingRows : "");
				this._headingColumnsInput.set_value(this._headingColumns ? this._headingColumns : "");
				this._captionTextArea.value = this._caption;
				this._summaryTextArea.value = this._summary;

				this._alignmentSelector.updateValue(this._captionHalign, this._captionValign);

				this._setCellIDCheckBox.checked = this._setCellID;
			}
		},

		_changeCellType: function (cellToConvert, newType) {
			var isChangeMade = false;
			if (cellToConvert.tagName.toUpperCase() != newType.toUpperCase()) {
				var newCell = this._tableDocument.createElement(newType.toLowerCase());

				this._mergeAttributes(newCell, cellToConvert);
				cellToConvert.parentNode.replaceChild(newCell, cellToConvert);
				isChangeMade = true;
			}
			return isChangeMade;
		},

		_mergeAttributes: function (destElem, sourceElem) {
			if (destElem.mergeAttributes) {
				destElem.mergeAttributes(sourceElem);
			}
			else {
				for (var attrName in sourceElem.attributes) {
					destElem.attrName = sourceElem.attributes[attrName];
				}
			}
			if (sourceElem.colSpan > 1) destElem.colSpan = sourceElem.colSpan;
			if (sourceElem.rowSpan > 1) destElem.rowSpan = sourceElem.rowSpan;
			destElem.style.cssText = sourceElem.style.cssText;
			destElem.innerHTML = sourceElem.innerHTML;
		},

		_updateTable: function () {
			if (null != this._table) {
				this._updateData(true);

				this._updateCaption();
				if (this._summary == "") {
					this._table.removeAttribute('summary', false);
				}
				else {
					this._table.summary = this._summary;
				}
				this._updateThead();
				this._updateRows();
				this._updateCellIDs();
			}

			return this._table;
		},

		_updateCaption: function () {
			var caption = this._table.caption;
			if ($telerik.isIE) {
				if (!caption && "" != this._caption)
					caption = this._table.createCaption();
				if (caption)
					caption.innerText = this._caption;
			}
			else {
				if (caption) {
					this._table.removeChild(caption);
					caption = null;
				}

				if (!caption && "" != this._caption) {
					var caption = this._tableDocument.createElement("caption");
					caption.innerHTML = this._caption;

					var table = this._table;
					var childNodes = table.childNodes;
					if (childNodes.length > 0)
						table.insertBefore(caption, childNodes[0]);
					else
						table.appendChild(caption);
				}
			}
			//set the lign of the caption
			this._setCaptionHalign(caption, this._captionHalign);
			this._setCaptionValign(caption, this._captionValign);
			//needed in IE
			if (caption) {
				caption.removeAttribute("align");
				caption.removeAttribute("vAlign");
			}
		},

		_setCaptionHalign: function (caption, align) {
			if (!caption) return;
			caption.style["textAlign"] = align;
		},

		_getCaptionHalign: function (caption) {
			if (!caption) return "";
			var align = caption.getAttribute("align");
			if (align) {
				var ucAlaign = align.toUpperCase();
				switch (ucAlaign) {
					case "LEFT":
					case "CENTER":
					case "TOP":
						this._setCaptionHalign(caption, align);
						break;
					case "TOP":
					case "BOTTOM":
						this._setCaptionValign(caption, align);
						break;
				}
			}
			caption.removeAttribute("align");
			return caption.style["textAlign"];
		},

		_setCaptionValign: function (caption, vAlign) {
			if (!caption) return;
			caption.style["verticalAlign"] = vAlign;
			caption.style["captionSide"] = vAlign;
		},

		_getCaptionValign: function (caption) {
			if (!caption) return;
			var vAlign = caption.getAttribute("vAlign");
			if (vAlign)
				this._setCaptionValign(caption, vAlign)

			var align = caption.getAttribute("align");
			if (align) {
				var ucAlaign = align.toUpperCase();
				switch (ucAlaign) {
					case "TOP":
					case "BOTTOM":
						this._setCaptionValign(caption, align);
						caption.removeAttribute("align");
						break;
				}
			}
			caption.removeAttribute("vAlign");
			return caption.style["verticalAlign"];
		},

		_getTableColumns: function () {
			var numColumns = 0;
			if (null != this._table && this._table.rows.length > 0) {
				numColumns = this._table.rows[0].cells.length;
			}
			return numColumns;
		},

		_getThead: function () {
			var arrElements = this._table.getElementsByTagName('THEAD');
			if (arrElements.length > 0)
				return arrElements[0];
			else
				return null;
		},

		_updateThead: function () {
			var numColumns = this._getTableColumns();
			var tHead = this._getThead();
			if (!tHead) {
				tHead = this._table.createTHead();
			}

			var tBodyInsertPos = 0;
			for (i = 0; i < this._table.rows.length; i++) {
				var row = this._table.rows[i];
				var parent = row.parentNode;

				var parentTagName = parent.tagName.toUpperCase();

				if (i < this._headingRows) {	// rows that have to be in THEAD
					if ("THEAD" != parentTagName) {
						var newRow = tHead.insertRow(tHead.rows.length);
						for (j = 0; j < row.cells.length; j++) {
							var newCell = this._tableDocument.createElement("th");

							//Copy all attributes from the source cell to the new cell.
							this._mergeAttributes(newCell, row.cells[j]);
							newRow.insertBefore(newCell, null);
						}
						this._table.deleteRow(i + 1);
					}
				}
				else {	// rows that have not be in THEAD
					if ("THEAD" == parentTagName) {
						var newRow = this._table.tBodies[0].insertRow(tBodyInsertPos++);
						for (j = 0; j < row.cells.length; j++) {
							var newCell = newRow.insertBefore(this._tableDocument.createElement("td"), null);
							//Copy all attributes from the source cell to the new cell.
							this._mergeAttributes(newCell, row.cells[j]);
						}
					}
				}
			}
			// remove the extra heading rows
			if (this._headingRows < tHead.rows.length) {
				for (i = tHead.rows.length - 1; i >= this._headingRows; i--) {
					tHead.deleteRow(i);
				}
			}

		},

		_updateRows: function () {
			if (this._table) {
				for (k = 0; k < this._table.tBodies.length; k++) {
					var tBody = this._table.tBodies[k];
					for (i = 0; i < tBody.rows.length; i++) {
						var row = tBody.rows[i];
						for (j = 0; j < row.cells.length; j++) {
							var cellType = j < this._headingColumns ? "TH" : "TD";
							this._changeCellType(row.cells[j], cellType);
						}
					}
				}
			}
		},

		_updateCellIDs: function () {
			var haveIds = this._checkHeadersHasIds();
			var haveHeaders = this._checkCellsHasHeaders();

			if (this._table && this._table.tHead && (this._setCellID || haveIds || haveHeaders)) {
				var tableID = this._table.id ? this._table.id : this._table.uniqueID;

				if (!tableID) {
					tableID = "table";
				}

				var arrHeaders = null;
				var headingId = 0;

				if (haveIds || this._setCellID) {
					for (i = 0; i < this._table.tHead.rows.length; i++) {
						var row = this._table.tHead.rows[i];
						if (!arrHeaders)
							arrHeaders = new Array(row.cells.length);

						for (j = 0; j < row.cells.length; j++) {
							var cell = row.cells[j];

							if (this._setCellID) {
								var id = cell.id ? cell.id : (tableID + "_heading_" + headingId++);
								cell.id = id;
								if (!arrHeaders[j])
									arrHeaders[j] = id;
							}
							else {
								cell.id = "";
							}
						}
					}
				}

				for (k = 0; k < this._table.tBodies.length; k++) {
					var tBody = this._table.tBodies[k];
					for (i = 0; i < tBody.rows.length; i++) {
						var row = tBody.rows[i];
						for (j = 0; j < row.cells.length; j++) {
							var cell = row.cells[j];
							var cellTagName = cell.tagName.toUpperCase();
							if ("TH" == cellTagName) {
								if (this._setCellID)
									cell.id = cell.id ? cell.id : (tableID + "_heading_" + headingId++);
								else
									cell.id = "";
							}
							else if ("TD" == cellTagName &&
									this._table.tHead.rows.length > 0 &&
									arrHeaders &&
									(haveHeaders || this._setCellID)) {
								if (this._setCellID)
									cell.setAttribute("headers", arrHeaders[j]);
								else
									cell.removeAttribute("headers", false);
							}
						}
					}
				}
			}
		},

		set_tableToModify: function (value) {
			this._table = value;
		},

		dispose: function () {
			this._clientParameters = null;
			this._table = null
			this._tableDocument = null;
			this._headingRows = null;
			this._headingColumns = null;
			this._caption = null;
			this._summary = null;
			this._captionHalign = null;
			this._captionValign = null;
			this._setCellID = null;
			this._headingRowsInput = null;
			this._headingColumnsInput = null;
			this._captionTextArea = null;
			this._summaryTextArea = null;
			this._setCellIDCheckBox = null;
			this._alignmentSelector = null;

			Telerik.Web.UI.Widgets.AccessibleTable.callBaseMethod(this, "dispose");
		}
	}

	Telerik.Web.UI.Widgets.AccessibleTable.registerClass('Telerik.Web.UI.Widgets.AccessibleTable', Telerik.Web.UI.RadWebControl, Telerik.Web.IParameterConsumer);
</script>

<div class="redTableWizard">
	<div class="redSection redSectionTop ">
		<div class="redRow">
			<span class="rfdAspLabel rfdAspTitle redInlineBlock">
				<script type="text/javascript">document.write(localization["HeadingsLabel"]);</script>
			</span>
		</div>
		<div class="redRow">
			<label class="redLabel" for="headingRows">
				<script type="text/javascript">document.write(localization["Rows"]);</script>
			</label>
			<span class="redInlineBlock redMiddle">
				<tools:EditorSpinBox ID="headingRows" runat="server"></tools:EditorSpinBox>
			</span>
			<label class="redLabel" for="headingColumns">
				<script type="text/javascript">document.write(localization["Columns"]);</script>
			</label>
			<span class="redInlineBlock redMiddle">
				<tools:EditorSpinBox ID="headingColumns" runat="server"></tools:EditorSpinBox>
			</span>
		</div>
	</div>

	<div class="redSection redSectionNoBorder">
		<div class="redRow">
			<label class="redLabel" for="CaptionText">
				<script type="text/javascript">document.write(localization["Caption"]);</script>
			</label>
			<input id="CaptionText" type="text" class="redCaptionInput" />
			<span class="redInlineBlock redMiddle redToolSplitButton">
				<tools:AlignmentSelector ID="alignmentSelector" runat="server"></tools:AlignmentSelector>
			</span>
		</div>

		<div class="redRow">
			<label class="redLabel" for="CaptionText">
				<script type="text/javascript">document.write(localization["Summary"]);</script>
			</label>
			<textarea id="SummaryText" class="redSummaryTextarea"></textarea>
		</div>

		<div class="redRow">
			<label class="redLabel">
			</label>
			<span class="redInlineBlock redMiddle">
				<input type="checkbox" id="associateCellsWithHeaders" />
				<label for="associateCellsWithHeaders">
					<script type="text/javascript">document.write(localization["AssociateCellsWithHeaders"]);</script>
				</label>
			</span>
		</div>
	</div>
</div>
